require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};

vHSButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}

vHSButtonFontStyle = { standardFont, 16, BlackColor };

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
	deleteselected = true;
	playername = ""; -- GetString("enternameprompt");
end


MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = MyFont,
			name = "entername",
			x=0,y=80,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "entername"
		};
		
		Bitmap
		{
			image="backgrounds/textfield3.png",
			x=kCenter,
			y=kCenter,
			
			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				label = playername,
				enablewindow = "enterok",
				clearinitial = deleteselected,
				x=3,y=5,w=kMax-3,h=kMax,
				length=20,
				ignore = kIllegalNameChars
				
			};
		};
			
		Button
		{
			x=80,
			y=-60,
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			name="enterok",
			label="ok",
			type = kPush,
			default=true,	-- Make this the default button
			command = 
				function()
					local newname = GetLabel("nameedit");
					-- crop leading and trailing spaces
					newname = string.gsub( newname, "^%s+", "" );
					newname = string.gsub( newname, "%s+$", "" );
					if (string.len( newname )==0 ) then
						DisplayDialog {
							"scripts/ok.lua",
							body ="pleaseenteraname",
							title = ""
						};
						SetFocus( "nameedit" )
					elseif (newname ~= playername and IsNameInUse(newname)) then
						DisplayDialog {
							"scripts/ok.lua",
							body ="nameinuse",
							title = ""
						};
						SetFocus( "nameedit" )
					else
						CloseWindow(newname);
					end
				end
		},
		
		Button
		{
			x=280,
			y=-60,
			graphics= vHSButtonGraphics,
			font	= vHSButtonFontStyle,
			name="entercancel",
			label="cancel",
			hflip   = true,
			type = kPush,
			command = 
				function()
					CloseWindow(nil);
				end
		};
	},
	
}

SetFocus( "nameedit" );

-- if (deleteselected) then
	-- EnableWindow("enterok", false);
-- end

